﻿//////////////////////////////////////////////
// UserTypeFieldDescriptor.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkScripts
#include "../Functions/FunctionDefines.h"
#include "../Functions/FunctionParameterType.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>

// Standards
#include <functional>

/// Class ------------------------------------

namespace nkScripts
{
	// Les types de callbacks
	using FieldGetter = std::function<OutputValue(void*)> ;
	using FieldSetter = std::function<void(const DataStack&)> ;

	struct UserTypeFieldDescriptor
	{
		// Les callbacks ouverts pour le field
		FieldGetter _getter ;
		FieldSetter _setter ;

		// Le nom
		nkMemory::String _fieldName ;

		// Le type de field
		FUNCTION_PARAMETER_TYPE _fieldType = FUNCTION_PARAMETER_TYPE::INT ;
		nkMemory::String _userTypeName ;
	} ;
}